#ifndef _SIMPLE_VECTOR_H_
#define _SIMPLE_VECTOR_H_


#include <complex>
typedef std::complex<double> mycomplex;


typedef double mytype;


double myabs(double val);
double myabs(mycomplex val);

class SimpleVector
{
public:
	///	Default contructor
	SimpleVector();
	///	Copy constructor
	SimpleVector(const SimpleVector& v);
	///	Destructor
	~SimpleVector();


	/// vector operations
	double Norma() const;


	///	overloaded operators
	SimpleVector& operator=(const SimpleVector& v);
	SimpleVector& operator+=(const SimpleVector& v);
	SimpleVector& operator-=(const SimpleVector& v);
	SimpleVector& operator*=(mytype a);
	SimpleVector& operator/=(mytype a);

	SimpleVector operator+(const SimpleVector& v) const;
	SimpleVector operator-(const SimpleVector& v) const;
	SimpleVector operator*(mytype a) const;
	SimpleVector operator/(mytype a) const;

	SimpleVector operator-()const;
	
	const mytype& operator[](int i) const;
	mytype& operator[](int i);

private:
	mytype _p[3];
};

SimpleVector operator*(mytype a, const SimpleVector& v);


#endif