#include <math.h>
#include "SimpleVector.h"


double myabs(double val)
{
	return fabs(val);
}

double myabs(mycomplex val)
{
	return sqrt(val.real()*val.real() + val.imag()*val.imag());
}



SimpleVector::SimpleVector()
{
	 _p[0] = 0;
	 _p[1] = 0;
	 _p[2] = 0; 
}

SimpleVector::SimpleVector(const SimpleVector& v)
{
	 _p[0] = v._p[0];
	 _p[1] = v._p[1];
	 _p[2] = v._p[2];
}

SimpleVector::~SimpleVector()
{
}



double SimpleVector::Norma() const
{
	double d = 0;

	for(int i=0; i<3; i++)
	{
		d += myabs(_p[i])*myabs(_p[i]);
	}
	return sqrt(d);
}


SimpleVector& SimpleVector::operator=(const SimpleVector& v)
{
	 _p[0] = v._p[0];
	 _p[1] = v._p[1];
	 _p[2] = v._p[2];
	return *this;
}

SimpleVector& SimpleVector::operator+=(const SimpleVector& v)
{
	*this = *this + v;
	return *this;
}

SimpleVector& SimpleVector::operator-=(const SimpleVector& v)
{
	*this = *this - v;
	return *this;
}

SimpleVector& SimpleVector::operator*=(mytype a)
{
	*this = *this * a;
	return *this;
}

SimpleVector& SimpleVector::operator/=(mytype a)
{
	*this = *this * a;
	return *this;
}


SimpleVector SimpleVector::operator+(const SimpleVector& v) const
{
	SimpleVector nv;

	nv[0] = v[0] + _p[0];
	nv[1] = v[1] + _p[1];
	nv[2] = v[2] + _p[2];

	return nv;
}

SimpleVector SimpleVector::operator-(const SimpleVector& v) const
{
	SimpleVector nv;

	nv[0] = _p[0] - v[0];
	nv[1] = _p[1] - v[1];
	nv[2] = _p[2] - v[2];

	return nv;
}

SimpleVector SimpleVector::operator*(mytype a) const
{
	SimpleVector nv;

	nv[0] = _p[0] * a;
	nv[1] = _p[1] * a;
	nv[2] = _p[2] * a;

	return nv;
}


SimpleVector SimpleVector::operator/(mytype a) const
{
	SimpleVector nv;

	nv[0] = _p[0] / a;
	nv[1] = _p[1] / a;
	nv[2] = _p[2] / a;

	return nv;
}


SimpleVector operator*(mytype a, const SimpleVector& v)
{
	return v*a;
}

const mytype& SimpleVector::operator[](int i) const
{
	return _p[i];
}

mytype& SimpleVector::operator[](int i)
{
	return _p[i];
}

SimpleVector SimpleVector::operator-()const
{
	SimpleVector nv;

	nv[0] = - _p[0];
	nv[1] = - _p[1];
	nv[2] = - _p[2];

	return nv;
}

