#!/usr/bin/perl

use strict;

my $hfile_dir = ".";

my $srcdir;	# source dir 
my $dstdir;	# destination dir	
my $pos=0;	# number of parsed files
my %fdb=();	# file number to file name
my $snum=1;
my %sdb=(GPRD_MAIN_SECT =>0); # section number to section name

sub usage{
	print "Usage: $0 [-t <target directory>] <src directory>\n";
	exit 1;
}# usage

sub err{
	print shift(@_)."\n";
	exit 1;
}# err


sub newsection{
	my $str = shift;
	my $sname = shift;

	if(!exists $sdb{$sname}){
		$sdb{$sname} = $snum;
		$snum++;
	}
	${$str} =~ s/\/\*GPRD\s+SECTION\s+[a-zA-Z0-9_]+\s+\*\//mod_section($sdb{$sname});/
}# newsection

sub sipc_act{
	my $str = shift;

	if(${$str} =~ /\/\*GPRD SCOMMRST\s+([0-9]+|\$r)\s+(SEND|RECV|ALL)\s+([^\s]+)?\s*\*\//i){
		my ($w, $a, $c) = ($1, $2, $3);
		$c = "MPI_COMM_WORLD" if (! defined($c));
		$a = ($a =~ /^SEND$/i)?0:1;
		chomp(${$str});
		${$str} =~ s/\/\*GPRD\s+SCOMMRST.*$//i;
		if($w !~ /^\$/){
			${$str} .= "if(_mod_rank_ == $w) ";
		}
		${$str} .= "mod_rstSIPC($a, $c);\n";
		return 1;
	}
	if(${$str} =~ /\/\*GPRD\s+SCOMMSET\s+([0-9]+|\$r)\s+(SEND|RECV|ALL)\s+\((.+)\)\s+([^\s]+)?\s*\*\//i){
		my ($w, $a, $ar, $c) = ($1, $2, $3, $4);
		my @arr;
		my $cnt;
		$c = "MPI_COMM_WORLD" if (! defined($c));
		$a = ($a =~ /^SEND$/i)?0:1;
		@arr = split(/\s*,\s*/, $ar);
		$ar = join(", ", @arr);
		$cnt = scalar(@arr);
		$ar =~ s/\$r/_mod_rank_/g; 
		chomp(${$str});
		${$str} =~ s/\/\*GPRD\s+SCOMMSET.*$//i;
		if($w !~ /^\$/){
			${$str} .= "if(_mod_rank_ == $w) ";
		}
		${$str} .= "mod_setSIPC($a, $c, $cnt, $ar);\n";
		return 1;
	}
	print "Wrong instruction ${$str}\n";
	return 0;
}# sipc_act

sub chkdirs{
	my $s = shift;
	my $d = shift;
	my $cd = `pwd`;
	my ($s_, $d_);
	
	chomp $cd;
	if( -d $s){	chdir $s;}else { err("$s is not a directory or doesn't exist"); }
	$s_ = `pwd`;
	chdir $cd;
	$d_ = $d;
	$d_ =~ s/[^\/]+\/?$//;
	if($d_ =~ /^$/){ $d_ = "."; }
	if( -d $d_){ chdir $d_; }else { err("$d_ is not a directory or doesn't exist"); }
	$d_ = `pwd`;
	chdir $cd;
	if($s_ =~ /^$d_$/) {err("target dir shouldn't be a subdir of the source one"); }
}# chkdirs

sub parseopt{
	$dstdir="";
	
	if(scalar(@ARGV) < 1){
		usage;
	}
	while(scalar(@ARGV)>1){
		my $k = shift(@ARGV);
		SWITCH:{
			if($k eq "-t"){
				$dstdir = shift(@ARGV);
				last SWITCH;
			}
			usage();
		}# SWITCH
	}
	$srcdir = shift(@ARGV);
	if(! defined($srcdir)){
		usage;
	}
	chop($srcdir) if($srcdir =~ /.+\/$/);
	if(! -d $srcdir ){
		err("Can't locate source directory '$srcdir'");
	}
	if($dstdir eq ""){
		$dstdir = $srcdir.".gprd";
	}
	# check for $dstdir is subdir of $srcdir
	chkdirs($srcdir, $dstdir);
	if( -d $dstdir ){
		err("Destination directory '$dstdir' exists. ".
			"Remove it permanently.");
	}else{
		mkdir($dstdir, 0755);
	}
}# parseopt

sub fcopy{
	my $if = shift;
	my $of = shift;
	my $buf = "";
	my $res1 = 0;
	my $res2 = 0;
	
	open(IF, $if) || err("Can't open file $if. $!");
	open(OF, ">$of") ||err("Can't open file $of. $!");
	while($res1 = sysread(IF, $buf, 1024)){
		$res2 = syswrite(OF, $buf, $res1);
		if($res1 != $res2){
			close(OF);
			close(IF);
			0;		
		}
	}
	close(OF);
	close(IF);
	1;
}# fcopy

sub makeHeader{
	my $dir = shift;
	open(OF, ">$dir/gepard_mon.h") || err("Can't open file $dir/gepard_mon.h. $!");
	print OF <<EOF;
#ifndef __MON_LIB_H__
#define __MON_LIB_H__

#include "mpi.h"

extern int _mod_rank_;

int mod_MPI_Init(int*, char***, unsigned);
int mod_MPI_Finalize(unsigned);

int mod_MPI_Bcast(void*, int, MPI_Datatype, int, MPI_Comm, unsigned); 
int mod_MPI_Reduce(void*, void*, int, MPI_Datatype, MPI_Op, int, MPI_Comm, unsigned); 
int mod_MPI_Recv(void*, int, MPI_Datatype, int, int, MPI_Comm, MPI_Status*, unsigned); 
int mod_MPI_Send(void*, int, MPI_Datatype, int, int, MPI_Comm, unsigned); 
int mod_MPI_Isend(void*, int, MPI_Datatype, int, int, MPI_Comm, MPI_Request*, unsigned); 
int mod_MPI_Irecv(void*, int, MPI_Datatype, int, int, MPI_Comm, MPI_Request*, unsigned); 
int mod_MPI_Wait(MPI_Request*, MPI_Status*, unsigned); 
int mod_MPI_Scatter(void*, int, MPI_Datatype, void*, int, MPI_Datatype, int, MPI_Comm, unsigned); 
int mod_MPI_Scatterv(void*, int*, int*, MPI_Datatype, void*, int, MPI_Datatype, int, MPI_Comm, unsigned); 
int mod_MPI_Gather(void*, int, MPI_Datatype, void*, int, MPI_Datatype, int, MPI_Comm, unsigned); 
int mod_MPI_Gatherv(void*, int, MPI_Datatype, void*, int*, int*, MPI_Datatype, int, MPI_Comm, unsigned);

int mod_MPI_Comm_dup(MPI_Comm, MPI_Comm*, unsigned);
int mod_MPI_Cart_create(MPI_Comm, int, int*, int*, int, MPI_Comm*, unsigned);
int mod_MPI_Comm_split(MPI_Comm, int, int, MPI_Comm*, unsigned); 
int mod_MPI_Comm_free(MPI_Comm*, unsigned);

//////////////////////////////////////////////////////////
// Additional commands
// ///////////////////////////////////////////////////////

// Count number of calls with the same id == pos
//  pos -    .
//     
//      pos 
//   (,   ...)
int mod_count(unsigned pos);
int mod_entry(unsigned pos);
int mod_section(unsigned);

#define _gepard_buf_size_	0x01
#define _gepard_load_to_	0x02
#define _gepard_read_to_	0x03
#define _gepard_idle_to_	0x04

void set_dc_initval(unsigned int, unsigned int); // what, value

///////////////////////////////////////////////////////////
// System of interprocesses communications
///////////////////////////////////////////////////////////

int mod_setSIPC(int, MPI_Comm, unsigned, ...);
int mod_rstSIPC(int, MPI_Comm);

#endif
EOF
	close(OF);
	print("Header file created\n");
}# makeHeader

my @pat = (
	"(MPI_Init)[\\s]*\\(([^)]+)\\)",
	"(MPI_Finalize)[\\s]*\\(([\\s]*)\\)",
	"(MPI_Send)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Recv)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Isend)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Irecv)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Bcast)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Reduce)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Wait)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Scatter)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Scatterv)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Gather)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Gatherv)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Comm_dup)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Comm_free)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Comm_split)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Cart_create)[\\s]*\\((([,]?[^,]*)*)\\)",
	"(MPI_Cart_sub)[\\s]*\\((([,]?[^,]*)*)\\)"
);
sub parseFile{
	my $sd = shift;
	my $dd = shift;
	my $fn = shift;
	my @buf=();
	my $flag=0;
	my $p = $pos<<16;	
	open(IF, "$sd/$fn");
	if($?){
		print "Can't open file $sd/$fn. $!\n";
		0;
	}
	@buf = <IF>;
	close(IF);
	open(OF, ">$dd/$fn");
	if($?){
		print "Can't open file $dd/$fn. $!\n";
		0;
	}
	for (my $i=0; $i<(scalar @buf); $i++){
		$p++;
		foreach my $k(@pat){
			if($buf[$i] =~ s/$k/mod_$1($2, $p)/){
				$buf[$i] =~ s/\([\s]*\, /\(/;
				$flag++;
				last; 
			}
		}
		
		if($buf[$i] =~ /\/\*GPRD\s+SECTION\s+([a-zA-Z0-9_]+)\s+\*\//){
			newsection(\$buf[$i], $1);
			next;
		}
		next if($buf[$i] =~ s/\/\*GPRD\s+BUFFER\s*=\s*([0-9]+)\s+\*\//set_dc_initval(_gepard_buf_size_, $1);/);
		next if($buf[$i] =~ s/\/\*GPRD\s+LAVGTO\s*=\s*([0-9]+)\s+\*\//set_dc_initval(_gepard_load_to_, $1);/);
		next if($buf[$i] =~ s/\/\*GPRD\s+IDLETO\s*=\s*([0-9]+)\s+\*\//set_dc_initval(_gepard_idle_to_, $1);/);
		next if($buf[$i] =~ s/\/\*GPRD\s+KILLTO\s*=\s*([0-9]+)\s+\*\//set_dc_initval(_gepard_read_to_, $1);/);

		next if($buf[$i] =~ s/\/\*GPRD\s+COUNT\s+\*\//mod_count($p);/);
		next if($buf[$i] =~ s/\/\*GPRD\s+ENTRY\s+\*\//mod_entry($p);/);
		
		if($buf[$i] =~ /\/\*GPRD\s+SCOMM(SET|RST)\s+.+\*\//){
			sipc_act(\$buf[$i]);
			next;
		}
	} # for
	if($flag){
		print OF "#include \"gepard_mon.h\"\n";
	}	
	print OF @buf;
	
	close(OF);
	1;
}# parseFile

sub parsedir{
	my $sdir = shift;
	my @files;

	opendir(DIR, "$srcdir/$sdir") || die "can't opendir $sdir: $!";
	@files = grep{! /^\.{1,2}$/} readdir(DIR);
	closedir(DIR);
	$pos = 0;
	foreach my $f (@files){
		if( -d "$srcdir/$sdir/$f" ){
			print "Parse directory $srcdir/$sdir/$f\n";
			mkdir("$dstdir/$sdir/$f", 0755);
			parsedir("$sdir/$f");
			print "Exit from $srcdir/$sdir/$f\n";
			next;
		}
		if( -f "$srcdir/$sdir/$f"){
			if($f !~ /\.c(c|pp)?$/i){
				print "Copying file $f ...";
				if(! fcopy("$srcdir/$sdir/$f", "$dstdir/$sdir/$f")){
					err(" failed");
				}
				print "done\n";
			}else{
				print "Parse file $f ...";
				if(!parseFile("$srcdir/$sdir", "$dstdir/$sdir", "$f")){
					err(" failed");
				}
				$fdb{$pos} = "$sdir/$f";
				$fdb{$pos} =~ s/^\///;
				$pos++;
				print "done\n";
			}
			next;
		}
		err("$srcdir/$sdir/$f is not directory or a regular file");
	}
}# parsedir

sub makeFDB{
	my $dir = shift;
	open(FD, ">$dir/appl.fdb") || err("Can't create file $dir/appl.fdb: $!");
	print FD "[FILES]\n";
	foreach my $k(sort keys %fdb){
		print FD "$k:$fdb{$k}\n";
	}
	print FD "[SECTIONS]\n";
	foreach my $k(keys %sdb){
		print FD "$sdb{$k}:$k\n";
	}
	close FD;
}# makeFDB
##############################
## main programm
##############################
parseopt;
makeHeader($dstdir);
parsedir("");
makeFDB($dstdir);

print <<EOT;
	* Add search path to header file gepard_mon.h. gepard_mon.h copyed
	  to destination directory ($dstdir).
	* Add mon.a library to link your project with
	* Copy file appl.fdb into the directory where trace log file is, and
	  rename it to _log_file_name_.fdb
EOT

__END__

