#include<mpi.h>
#include<stdio.h>
#include<stdlib.h>
#include<math.h>
#define in 31     /*     */
#define jn 31
#define kn 31
#define a 1
#define P 4

double Fresh(double,double,double);    /*       */
double Ro(double,double,double);     /*  Ro   */
void Inic(int,int,int,int); 
int Plosk(int,int*); 


double F[(in+2)/P+2][jn+1][kn+1], Fi, Fj, Fk, F1; 
double hx, hy, hz, owx, owy, owz, c, e;
int dt, ds;

 double Fresh(double x,double y,double z)
          { double res;
	    res = x + y + z;
	    return res;
	  }

 double Ro(double x, double y, double z)	           	
 	  { double d;
	    d = -a*(x+y+z);
	    return d;
	  }
	  
    /*        */

 void Inic(int im0, int im1, int fi0, int fi1)    
      { int i, j, k;
        for(i = im0; i <= im1; i++)
          { for(j = 0; j <= jn; j++)
             { for(k = 0; k <= kn; k++)
                { if((i!=fi0)&&(j!=0)&&(k!=0)&&(i!=fi1)&&(j!=jn)&&(k!=kn))
	           { F[i][j][k] = 0;
	           }
	          else
	           { F[i][j][k] = Fresh((i+dt)*hx,j*hy,k*hz);  	 
                   }
	         }
	      }
           } 
       }


     /*  .  */

 int Plosk(int i, int *fn)
      { int j, k;  
        for(j = 1; j < jn; j++)
	  { for(k = 1; k < kn; k++)
	      { F1 = F[i][j][k];
	        Fi = (F[i+1][j][k] + F[i-1][j][k]) / owx;
	        Fj = (F[i][j+1][k] + F[i][j-1][k]) / owy;
	        Fk = (F[i][j][k+1] + F[i][j][k-1]) / owz;
	        F[i][j][k] = (Fi + Fj + Fk - Ro((i+dt)*hx,j*hy,k*hz)) / c;
	        if(fabs(F[i][j][k] - F1) > e)
		  *fn = 0;
	      }
	   }
      return(*fn);     
        }
 

int main(int argc, char **argv)
  { 
    double X, Y, Z;
    double max, N, F1, t1, t2;
    int i, j, k, mi, mj, mk, fon, fons, rin;
    int size, rank, R, fl, fl1, fl2;
    int fend, it;
    MPI_Status st; 
    MPI_Request req[2];

    MPI_Init(&argc, &argv);            

    fend = it = 0;
    X = 2.0;
    Y = 2.0;
    Z = 2.0;
    e = 0.00001;
         
    hx = X/in;     /*   */
    hy = Y/jn;
    hz = Z/kn;
    
    owx = pow(hx,2);
    owy = pow(hy,2);
    owz = pow(hz,2);

    rin = (in + 1)/P;
    R = (jn + 1) * (kn + 1);

    c = 2/owx + 2/owy + 2/owz + a; 
    
    MPI_Comm_size(MPI_COMM_WORLD, &size);
    MPI_Comm_rank(MPI_COMM_WORLD, &rank);

    dt = rank * rin - 1;         

	/*   */

    t1 = MPI_Wtime();

    if(rank == 0)
      { dt = dt + 1;
        ds = 1;
        Inic(0, rin-1, 0, -1);
        fl = 0;
        do
	 { fon = 1;
	   for(i = 1; i <= rin-2; i++)
	     fon = Plosk(i, &fon);
	   if(fl != 0)
	     MPI_Wait(&req[0],&st);
	     fon = Plosk(rin-1,&fon);  
	     fl = 1;
	     it++;
	   MPI_Send(&F[rin-1][0][0], R, MPI_DOUBLE, rank+1, 2, MPI_COMM_WORLD);
	   MPI_Send(&fon, 1, MPI_INT, rank+1, 1, MPI_COMM_WORLD);
	   if(fon == 0)
            MPI_Irecv(&F[rin][0][0], R, MPI_DOUBLE, rank+1, 3, MPI_COMM_WORLD, &req[0]);
           else
	     break;	 
         }    
        while(1);
       }
      
   else      
    if(rank == size-1)
      { ds = 1;
        Inic(1, rin, -1, rin);    
        fl1 = 0;	
        do
         { if(fl1 == 0)
	     { MPI_Recv(&F[0][0][0], R, MPI_DOUBLE, rank-1, 2, MPI_COMM_WORLD, &st);
	       MPI_Recv(&fend, 1, MPI_INT, rank-1, 1, MPI_COMM_WORLD, &st);
	       fon = Plosk(1, &fon);
               fl2 = 2;
               if(fend == 0)
	        MPI_Send(&F[1][0][0], R, MPI_DOUBLE, rank-1, 3, MPI_COMM_WORLD);
	       fl1 = fend;
	     }
    	   fon = 1;
           for(i = fl2; i <= rin-1; i++)  
            fon = Plosk(i, &fon); 
           it++;
	   if(fon && fl1 != 0)
	      break;
	   fl2 = 1;
	  } 
	 while(1);
       }
        	 
     else
       { ds = 0;
         Inic(1, rin, -1, -1);
         fl = fl1 = 0;  
         do
          { if(fl1 == 0)
	     { MPI_Recv(&F[0][0][0], R, MPI_DOUBLE, rank-1, 2, MPI_COMM_WORLD, &st);
	       MPI_Recv(&fend, 1, MPI_INT, rank-1, 1, MPI_COMM_WORLD, &st);
	       fon = Plosk(1, &fon);
               fl2 = 2;
               if(fend == 0)
	        MPI_Send(&F[1][0][0], R, MPI_DOUBLE, rank-1, 3, MPI_COMM_WORLD);
	       fl1 = fend;
	     }
    	   fon = 1;
           for(i = fl2; i <= rin-1; i++)  
            fon = Plosk(i, &fon); 
	   if(fl != 0)
	     MPI_Wait(&req[0],&st);
	     fon = Plosk(rin,&fon);  
	     fl = 1;
	     it++;
           fons = (fon && fl1);
	   MPI_Send(&F[rin][0][0], R, MPI_DOUBLE, rank+1, 2, MPI_COMM_WORLD);
	   MPI_Send(&fons, 1, MPI_INT, rank+1, 1, MPI_COMM_WORLD);
	    MPI_Irecv(&F[rin+1][0][0], R, MPI_DOUBLE, rank+1, 3, MPI_COMM_WORLD, &req[0]);
	   if(fon && fl1 != 0)    
	     break;
	   fl2 = 1;    	 
         }    
        while(1);
       }	 

    t2 = MPI_Wtime();
    printf("\n rank = %d iter = %d  T = %f\n",rank,it,t2-t1);
    
    max = 0.0;
        /*       */
      
 
      { for(i = 1; i <= rin - ds; i++)
         { for(j = 1; j < jn; j++)
	     { for(k = 1; k < kn; k++)
	         { if(fabs((F1 = F[i][j][k] - Fresh((i+dt)*hx,j*hy,k*hz))) > max)
      	             { max = F1;
	               mi = i+dt; mj = j; mk = k;
		     }
		  }
              }
	  }	      		       	 
    
  printf("Rank=%d  Max difference = %f\n in point(%d,%d,%d)\n",rank,max,mi,mj,mk); 
      }
 
 M1:  MPI_Finalize();
      return(0);
 
  }
