/*  
 *
 *    .   -  .
 * (   8- ).
 */
   #include<stdio.h>
   #include<mpi.h>
   #include<sys/time.h>
/*        MA    .
 * (,         
 * .) */
   #define M 40
   #define N 10
   #define tegD 1
   #define EL(x) (sizeof(x) / sizeof(x[0]))
/*       - MA   V   
 * .  ,      
 *     .    
 *    . */
double MA[N][M+1], V[M+1], MAD, R;

int main(int args, char **argv)
  { int size, MyP, i, j, v, k, d, p;
    int        *index, *edges;
    MPI_Comm   comm_gr;
    MPI_Status status;
    struct timeval tv1, tv2; 
    int dt1; 
    int reord = 1;
 /*   */
    MPI_Init(&args, &argv);
 /*      */
    MPI_Comm_size(MPI_COMM_WORLD, &size);
 /*    () */
    MPI_Comm_rank(MPI_COMM_WORLD, &MyP);
 /*           
  *   */
    index = (int *)malloc(size * sizeof(int));
    edges = (int *)malloc(size*(size-1) * sizeof(int));
 /*         
  *      " ". */
    for(i = 0; i < size; i++)
      { index[i] = (size - 1)*(i + 1);
        v = 0;
        for(j = 0; j < size; j++)
          { if(i != j)
              edges[i * (size - 1) + v++] = j;
          }
      }
    MPI_Graph_create(MPI_COMM_WORLD, size, index, edges, reord, &comm_gr);
/*       A    
 *  ,      A.
 *     ,   -   
 *  .. (    -  = 2,   = 1). */
    for(i = 0; i < N; i++)
      { for(j = 0; j < M; j++)
          { if((N*MyP+i) == j)
              MA[i][j] = 2.0;
            else
              MA[i][j] = 1.0;
          }
        MA[i][M] = 1.0*(M)+1.0;
      }
 /*         */
    gettimeofday(&tv1, (struct timezone*)0);
 /*   */
 /*  p -   .  ,   , 
  *      . ,   
  *   ,  , ,    
  * ,    . */
    /*GPRD SECTION right_move */
    for(p = 0; p < size; p++)
      { 
     /*  k -   . (  ""  ). */
        for(k = 0; k < N; k++)
          { if(MyP == p)
              { 
             /*     MyP == p     
              *  . 
              *   k  ,     MyP */
                MAD = 1.0/MA[k][N*p+k];
                for(j = M; j >= N*p+k; j--)
                  MA[k][j] = MA[k][j] * MAD;
                for(d = p+1; d < size; d++)
                  MPI_Send(&MA[k][0], M+1, MPI_DOUBLE, d, tegD, comm_gr);
                for(i = k+1; i < N; i++)
                  { for(j = M; j >= N*p+k; j--)
                      MA[i][j] = MA[i][j]-MA[i][N*p+k]*MA[k][j];
                  }
              }
         /*      MyP > p */
            else if(MyP > p)
              {  MPI_Recv(V, EL(V), MPI_DOUBLE, p, tegD, comm_gr, &status);
                 for(i = 0; i < N; i++)
                   { for(j = M; j >= N*p+k; j--)
                       MA[i][j] = MA[i][j]-MA[i][N*p+k]*V[j];
                   }
              }
          }        /* for k */
       }           /* for p */
 /*   */
 /*   p  k ,     . */
    /*GPRD SECTION back_move */
    for(p = size-1; p >= 0; p--)
      { for(k = N-1; k >= 0; k--)
          { 
         /*    */
            if(MyP == p)
              { for(d = p-1; d >= 0; d--)
                  MPI_Send(&MA[k][M], 1, MPI_DOUBLE, d, tegD, comm_gr);
                for(i = k-1; i >= 0; i--)
                  MA[i][M] -= MA[k][M]*MA[i][N*p+k];
              }
         /*     MyP < p */
            else
              { if(MyP < p)
                  { MPI_Recv(&R, 1, MPI_DOUBLE, p, tegD, comm_gr, &status);
                    for(i = N-1; i >= 0; i--)
                      MA[i][M] -= R*MA[i][N*p+k];
                  }
              }
          }                /* for k */
      }                    /* for p */
    /*GPRD SECTION GPRD_MAIN_SECT */
 /*       */
    gettimeofday(&tv2, (struct timezone*)0);
    dt1 = (tv2.tv_sec - tv1.tv_sec)*1000000 + tv2.tv_usec - tv1.tv_usec;
    printf("MyP = %d Time = %d\n", MyP, dt1);
 /*   ,  ,      */
    printf("MyP = %d %f %f %f %f\n",MyP,MA[0][M],MA[1][M],MA[2][M],MA[3][M]);
/*     */
    MPI_Finalize();
    return(0);
  }

